#!/bin/sh
#===============================================================================
# Bernd Martin Dot Net 
# photo-gallery-berndmartin.sh
#===============================================================================
# This photo gallery generator script prepares in the main directory photos 
# several html files for the main dir and for all sub-directories under the path
# photos/... 
# The script generates: 
# 1. a main html file with the name photos/gallery.html
# 2. for all subdirectories a html file with the name photos/[dir-name].html 
#    and only for the first level of sub-directories. All pictures have to be 
#    located in the sub-directories.
#==============================================================================

# change directory to the working dir
workdir=./photos
cd "$workdir"
n='\n'
# name of the main gallery
mainfile=gallery.html
mainnavi=''
# prepare the html header
head='<!DOCTYPE html>\n
<html>\n
  <head>\n
        <title>gallery | Bernd Martin Dot Net</title>\n
        <meta charset="UTF-8">\n
        <link href="http://fonts.googleapis.com/css?family=Lato:100|Codystar:300" rel="stylesheet" type="text/css">\n
        <link rel="shortcut icon" href="./../img/favicon.ico" type="image/x-icon">\n
        <link rel="icon" href="./../img/favicon.ico" type="image/x-icon">\n
        <meta name="viewport" content="width=device-width">\n
        <link rel="stylesheet" type="text/css" href="./../css/gcs.css"/>\n 
	</head>\n
	<body>\n
		<footer>\n
	    	<a href="http://bmline.de" style="color:white">BMline.de</a> | 
	    	<a href="http://berndmartin.net/contact.html#2" style="color:white">Contact</a> | 
	    	<a href="http://berndmartin.net/contact.html#3" style="color:white">Impressum</a>\n
		</footer>\n
    <section id="slider" class="error" title="gallery">\n
      <div class="slide_container">\n'
# prepare the html navigation and the footer navigation
navi='</div>\n</section>\n<div class="nav-container"><ul>\n
        <li><a href="http://berndmartin.net"             >Bernd Martin Dot Net</a></li>\n'
foot='</ul></div></body></html>\n'      

# create head for file gallery.html
echo $head>$mainfile
# figure of gallery
cntfigure=$[0]
# loop all sub-directories
for i in `find . -mindepth 1 -type d -maxdepth 1 `
do
	# remove ./ from variable
	dir=${i/.\//}
	# get last picture from directory for the gallery.html
	picture="$(ls  $dir/ | tail -1)"
	# set new file name [sub-dir].html of a directory
	outfile=$dir.html
	# write header to image.html and replace the word gallery with the name of the sub-dir 
	echo ${head/gallery/$dir}'\n'>$outfile
	# set big-picture counter
	count=$[0]
	# set counter for figure in gallery.html - when create more than 10 > set back to zero
	if [ $cntfigure -gt 10 ]
	then 
		cntfigure=$[0]
	fi
	cntfigure=$[cntfigure+1]
	
	# set name of a sub-dir in uppercase as name of the slider 
	galname=$(echo ${dir//-/ } | tr '[:lower:]' '[:upper:]')
	# div for image-gallery
	bigpic='<div class="image-gallery">\n<div class="big-image">\n'
	# end of div for image-gallery and start div thumbs
	smapic='</div>\n<h2>'$galname'</h2>\n<a class="button prev"><</a>\n<a class="button next">></a>\n<div class="thumbs">\n <ul>\n'

	# loop all files in subdirectory of type *.jpg, *.png, *.bmp ...
	for pic in `find $dir -maxdepth 1 -type f \( -iname "*.jpg" -o -iname "*.png" -o -iname "*.bmp" -o -iname "*.gif" -o -iname "*.svg" \)  `
    do
    	count=$[count+1]
    	if [ "$dir/$picture" = "$pic" ]
        then
        # set default picture as first displayed picture in a folder - example: named your wish default file zzz.jpg 
		bigpic=$bigpic'<img id="default" src="'$pic'" alt="'$dir'" />'$n
		smapic=$smapic'<li><a href="#default"><img id="default" src="'$pic'" width="25px" height="25px" alt="'$dir'" /></a></li>'$n 
		else
		bigpic=$bigpic'<img id="image'$count'" src="'$pic'" alt="'$dir'" />'$n
		smapic=$smapic'<li><a href="#image'$count'"><img id="image'$count'" src="'$pic'" width="25px" height="25px" alt="'$dir'" /></a></li>'$n 
    	fi
	done
	# write [sub-dir].html 
	echo $bigpic>>$outfile
	echo $smapic>>$outfile

	# write navigation & footer to [sub-dir].html 
	echo '</ul></div></div>'>>$outfile
	echo $navi>>$outfile
	echo '<li><a href="./gallery.html" >Gallery</a></li>\n'>>$outfile
	echo $foot>>$outfile

	# build image of gallery.html
	maingallery=$maingallery'<figure class="pic'$cntfigure'"><a href="'$dir'.html" ><img src="'$dir/$picture'"
	                         title="'$galname'" alt="'$galname'"/></a> <figcaption>'$galname'</figcaption></figure>\n' 
done
# main part of gallery
echo '<div id="background">\n<div id="gallery">\n'>>$mainfile
echo $maingallery>>$mainfile
echo '</div>\n</div>\n'>>$mainfile
# build navigation & footer of gallery.html
echo $navi>>$mainfile
echo '	<li><a href="http://berndmartin.net/main.html#2" >Inspiration</a></li>\n
        <li><a href="http://berndmartin.net/main.html#3" >Portfolio</a></li>\n
        <li><a href="http://berndmartin.net/main.html#4" >Projects</a></li>\n
        <li><a href="http://berndmartin.net/main.html#5" >About</a></li>\n'>>$mainfile
echo $mainnavi>>$mainfile
echo $foot>>$mainfile
# open mainfile in chrome browser
/usr/bin/open -a "/Applications/Google Chrome.app" "file:///"$(pwd)/$mainfile
exit